package przyklady;

import hr.model.*;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;

import java.util.Scanner;

public class P1_OdczytajPracownika {
    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        try(EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
            EntityManager em = emf.createEntityManager()) {

            while(true) {
                System.out.print("\nPodaj id pracownika: ");
                int id = sc.nextInt();
                if(id < 0) break;
                Employee employee = em.find(Employee.class, id);
                System.out.println(employee);
                System.out.println();
                // w przypadku braku takiego obiektu wynikiem jest null
                if(employee != null) {
                    System.out.println(employee.getFirstName()
                            + " " + employee.getLastName() + " zarabia " + employee.getSalary());
                    Job job = employee.getJob();
                    System.out.println("Job: " + job + " " + job.getJobId() + " = " + job.getJobTitle());
                    Department dep = employee.getDepartment();
                    if(dep != null) {
                        System.out.println("Klasa obiektu Department: " + dep.getClass().getName());
                        // w przypadku zależności LAZY, dopiero teraz zostaną wczytane szczegóły departamentu
                        System.out.println("Department: " + dep.getDepartmentName());
                        System.out.println("Adres: " + dep.getLocation().getStreetAddress()
                                + " " + dep.getLocation().getCity()
                                + " " + dep.getLocation().getCountry().getCountryName());
                    }
                }
            }
        }
    }
}
