package przyklady;

import hr.model.Country;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import org.hibernate.Session;

public class P0_OdczytajKraj {
    public static void main(String[] args) {
        System.out.println("Początek main");
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
        System.out.println("Jest fabryka: " + emf);

        EntityManager em = emf.createEntityManager();
        System.out.println("Jest EM: " + em + " , klasa: " + em.getClass().getName());

        Country country = em.find(Country.class, "UK");
        System.out.println(country);
        System.out.println("Kod kraju: " + country.getCountryId() + ", nazwa: " + country.getCountryName());

        // Gdy naszą implementacją jest Hibernate,
        // obiekt EntityManager jest implementowany jako obiekt org.hibernate.Session
        // Gdyby tej wersji użyć - to będziemy mieli do dyspozycji więcej metod.
        Session session = em.unwrap(Session.class);
        // Session session = (Session)em;
        Country country2 = session.byId(Country.class).load("US");
        System.out.println("Kod kraju: " + country2.getCountryId() + ", nazwa: " + country2.getCountryName());

        System.out.println("Zamykamy...");
        em.close();
        emf.close();
        System.out.println("Koniec main");
    }
}
