package hr.model;

import jakarta.persistence.*;
import org.hibernate.annotations.ColumnDefault;

import java.util.LinkedHashSet;
import java.util.Set;

@Entity
@Table(name = "departments")
public class Department extends AbstractEntity {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ColumnDefault("nextval('departments_seq')")
    @Column(name = "department_id", nullable = false)
    private Integer id;

    @Column(name = "department_name", nullable = false, length = 100)
    private String departmentName;

    @Column(name = "manager_id")
    private Integer managerId;

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "location_id")
    private hr.model.Location location;

    /* Kolekcje (List i Set) prowadzące do innych obiektów encji
       są domyślnie wiązane w trybie LAZY.
       Oznacza to, że lista nie jest od razu uzupełniane elementami,
       a następuje to dopiero przy pierwszym dostępie do jej zawartości.

       W trybie EAGER lista byłaby wypeniana danymi od razu,
       co byłoby potencjalnie dużym problemem wydajnościowym
       (zwn na dalsze powiązania tamtych obiektów itd...)
     */
    @OneToMany(mappedBy = "department")
    private Set<Employee> employees = new LinkedHashSet<>();

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Integer getManagerId() {
        return managerId;
    }

    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    public hr.model.Location getLocation() {
        return location;
    }

    public void setLocation(hr.model.Location location) {
        this.location = location;
    }

    public Set<Employee> getEmployees() {
        return employees;
    }

    public void setEmployees(Set<Employee> employees) {
        this.employees = employees;
    }

}