package hr.model;

import jakarta.persistence.*;

@Entity
@Table(name = "countries")
public class Country extends AbstractEntity {
    @Id
    @Column(name = "country_id", nullable = false, length = 2)
    private String countryId;

    @Column(name = "country_name", length = 40)
    private String countryName;

    @ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "region_id")
    private hr.model.Region region;

    public String getCountryId() {
        return countryId;
    }

    public void setCountryId(String countryId) {
        this.countryId = countryId;
    }

    public String getCountryName() {
        return countryName;
    }

    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    public hr.model.Region getRegion() {
        return region;
    }

    public void setRegion(hr.model.Region region) {
        this.region = region;
    }

}