package hr.model;

import java.lang.reflect.Field;
import java.util.Collection;

/** Wspólna nadklasa dla wszystkich klas encji w tym pakiecie.
 *  Miejsce na dodatkowe metody.
 *  Wykorzystuję je na zdefiniowanie "uniwersalnego toString" za pomocą mechanizmów refleksji.
 *  Mały problem: wypisanie obiektu powoduje wymuszenie załadowania wszyskich jego pól,
 *  nawet jeśli są "LAZY" z punktu widzenia Hibernate.
 *  Dla kolekcji dodałem specjalnego ifa, który nie powoduje wejścia do wnętrza kolekcji.
 */
abstract class AbstractEntity {
    public String hello() {
        return "hello";
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        Class<? extends AbstractEntity> klasa = this.getClass();
        result.append(klasa.getSimpleName()).append(" [");
        int fieldNo = 0;

        for(Field field : klasa.getDeclaredFields())
            try {
                if(fieldNo++ > 0) {
                    result.append(", ");
                }
                Object value = "";
                if(Collection.class.isAssignableFrom(field.getType())) {
                    value = "[…]";
                } else if(field.trySetAccessible()) {
                    value = field.get(this);
                } else {
                    value = "!";
                }
                result.append(field.getName()).append('=').append(value);
            } catch (IllegalArgumentException | IllegalAccessException e) {
                System.err.println(e);
            }
        result.append("]");

        return result.toString();
    }

}
