package hr.gotowe;

import java.util.Scanner;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import hr.model.Employee;

public class OdczytajManagerow {

    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);
        EntityManagerFactory emf = null;
        EntityManager em = null;
        try {
            emf = Persistence.createEntityManagerFactory("hr");
            em = emf.createEntityManager();
        
            while(true) {
                System.out.print("\nPodaj id pracownika: ");
                if(!sc.hasNextInt())
                    break;
                int id = sc.nextInt();
                Employee emp = em.find(Employee.class, id);
                
                if(emp == null) {
                    System.out.println("nie znaleziono takiego pracownika");
                    continue;
                }

                while(emp.getManager() != null) {
                    emp = em.find(Employee.class, emp.getManager());
                    System.out.println("Managerem jest:");
                    System.out.println("    " + emp.getId() + " " + emp.getFirstName() + " " + emp.getLastName()
                        + " (" + emp.getJob().getJobTitle() + ") $" + emp.getSalary());
                }
            }
        } finally {
            if(em != null)
                em.close();
            if(emf != null)
                emf.close();
        }
    }
}
