package hr.gotowe;

import java.util.List;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Root;
import hr.model.Employee;

public class Criteria1 {

    public static void main(String[] args) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("hr");
        EntityManager em = emf.createEntityManager();

        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery<Employee> cq = cb.createQuery(Employee.class); // typ wyniku
        Root<Employee> root = cq.from(Employee.class); // tabela źródłowa
        cq.select(root);
        
        TypedQuery<Employee> query = em.createQuery(cq);
        
        List<Employee> lista = query.getResultList();
        System.out.println("Odczytano " + lista.size() + " rekordów.");
        for (Employee emp : lista) {
            System.out.printf("%-15s %-15s %8s %s\n", emp.getFirstName(), emp.getLastName(),
                    emp.getSalary(), emp.getJob().getJobTitle());
        }
        
        em.close();
        emf.close();
    }

}
