<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:param name="kategoria" />

	<xsl:output method="html" encoding="utf-8" />
	
	<!-- ustawienia dotyczące działania funkcji format-number -->
	<xsl:decimal-format decimal-separator="," grouping-separator=" "/>

	<xsl:template match="/">
		<html>
			<head>
				<title>Sklepik</title>
				<xsl:call-template name="wstaw-css"/>
			</head>
			<body>
				<h1>Asortyment sklepu</h1>
				<xsl:if test="$kategoria">
					<p>Wypisywanie są tylko towary z kategorii <xsl:value-of select="$kategoria"/></p>
				</xsl:if>

				<xsl:apply-templates select="/sklep/*[@id-kategorii = $kategoria or not($kategoria)]"/>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="kategoria">
		<div class="kategoria">
			<xsl:apply-templates />
			
			<ul>
			<!-- ten current() zwraca to, co zmatchowało się w tym wywołaniu template'a -->
			<xsl:for-each select="/sklep/towar[@id-kategorii = current()/@id-kategorii]">
				<xsl:sort select="nazwa" data-type="text"/>
				<li>
					<a href="#{@id-towaru}">
						<xsl:value-of select="nazwa"/>
					</a>
				</li>
			</xsl:for-each>
			</ul>
		</div>
	</xsl:template>
	
	<xsl:template match="towar">
		<div class="towar" id="{@id-towaru}">
			<xsl:apply-templates select="nazwa"/>
			
			<!-- TODO wypisz *nazwę* kategorii -->
			<p>Kategoria <xsl:value-of select="/sklep/kategoria[@id-kategorii = current()/@id-kategorii]/nazwa"/></p>
			
			<p>Cena brutto: <xsl:value-of select="format-number(cena, '# ##0,00')"/> zł</p>
			<p>Cena netto: <xsl:value-of select="format-number(cena div (1 + vat div 100), '# ##0,00')"/> zł</p>
			
			<xsl:apply-templates select="opis"/>
			
			<xsl:if test="cena-promocyjna">
				<p>Towar posiada cenę promocyjną.</p>
			</xsl:if>
		</div>
	</xsl:template>
	
	<xsl:template match="nazwa">
		<h2>
			<xsl:apply-templates />
		</h2>
	</xsl:template>
	
	<xsl:template match="opis">
		<p>
			<xsl:apply-templates />
		</p>
	</xsl:template>
	
	<xsl:template match="em">
		<strong>
			<xsl:apply-templates />
		</strong>
	</xsl:template>
	
	<xsl:template match="term">
		<dfn>
			<xsl:apply-templates />
		</dfn>
	</xsl:template>
	
	<xsl:template match="br">
		<br/>
	</xsl:template>

	<xsl:template match="link">
		<a href="{@href}">
			<xsl:apply-templates />
		</a>
	</xsl:template>


	<xsl:template name="wstaw-css">
		<style type="text/css">
body {
	background-color: #FFFFCC;
	fonst-size: 12pt;
	font-family: 'Roboto', 'Arial', sans-serif;
}

.kategoria, .towar {
	width: 800px;
	margin: 20px auto;
	padding: 10px;
}

.towar {
	background-color: #BBFFFF;
	border: 3px solid black;
}

.kategoria {
	background-color: #FFDDFF;
	border: 5px outset blue;
}

h2 {
	font-size: 16pt;
	font-weight: bold;
	text-align: center;
	margin-bottom: 1em;
}
		</style>
	</xsl:template>
	
</xsl:stylesheet>
