<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" encoding="utf-8" />

	<xsl:template match="/">
		<html>
			<head>
				<title>Sklepik</title>
				<xsl:call-template name="wstaw-css"/>
			</head>
			<body>
				<h1>Asortyment sklepu</h1>
				<xsl:apply-templates />
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="kategoria">
		<div class="kategoria">
			<xsl:apply-templates />
		</div>
	</xsl:template>
	
	<xsl:template match="towar">
		<div class="towar">
			<xsl:apply-templates select="nazwa"/>
			
			<p>Cena brutto: <xsl:value-of select="cena"/> zł</p>
			<p>Cena netto: <xsl:value-of select="cena div (1 + vat div 100)"/> zł</p>
			
			<xsl:apply-templates select="opis"/>
		</div>
	</xsl:template>
	
	<xsl:template match="nazwa">
		<h2>
			<xsl:apply-templates />
		</h2>
	</xsl:template>
	
	<xsl:template match="opis">
		<p>
			<xsl:apply-templates />
		</p>
	</xsl:template>
	
	<xsl:template match="em">
		<strong>
			<xsl:apply-templates />
		</strong>
	</xsl:template>
	
	<xsl:template match="term">
		<dfn>
			<xsl:apply-templates />
		</dfn>
	</xsl:template>
	
	<xsl:template match="br">
		<br/>
	</xsl:template>


	<xsl:template name="wstaw-css">
		<style type="text/css">
body {
	background-color: #FFFFCC;
	fonst-size: 12pt;
	font-family: 'Roboto', 'Arial', sans-serif;
}

.kategoria, .towar {
	width: 800px;
	margin: 20px auto;
	padding: 10px;
}

.towar {
	background-color: #BBFFFF;
	border: 3px solid black;
}

.kategoria {
	background-color: #FFDDFF;
	border: 5px outset blue;
}

h2 {
	font-size: 16pt;
	font-weight: bold;
	text-align: center;
	margin-bottom: 1em;
}
		</style>
	</xsl:template>
	
</xsl:stylesheet>
