package zad13;

import java.io.File;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

import util.Args;
import zad13.sklep.Sklep;
import zad13.sklep.Towar;

public class WypiszTowary_JAXB {

	public static void main(String[] args) {
		args = Args.argsOrDefault(args, "sklep_ns.xml");
		try {
			JAXBContext ctx = JAXBContext.newInstance(Sklep.class);
			Unmarshaller u = ctx.createUnmarshaller();
			Sklep sklep = (Sklep)u.unmarshal(new File(args[0]));

			for(Towar t : sklep.getTowary()) {
				System.out.println("Towar: "+t.getNazwa() + "  " + t.getCenaNetto());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
