package sklep;

import javax.xml.XMLConstants;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

import util.Args;

public class ZnajdzMaxCene {
	public static void main(String[] args) {
		args = Args.argsOrDefault(args, "sklep.xml", "sklep.xsd");
		
		try {
			MaxCenaHandler mojHandler = new MaxCenaHandler();
			//MyErrorHandler eh = new MyErrorHandler();
			
			SchemaFactory sf = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Schema schema = sf.newSchema(new StreamSource("sklep.xsd"));

			SAXParserFactory spf = SAXParserFactory.newInstance();
			spf.setSchema(schema);
			SAXParser parser = spf.newSAXParser();
			XMLReader reader = parser.getXMLReader();
			
			reader.setContentHandler(mojHandler);
			//reader.setErrorHandler(eh);
			reader.parse(args[0]);
			double maxCena = mojHandler.max();
			System.out.println("Max cena = "+maxCena);
			
		} catch (SAXException e) {
			System.out.println("Blad parsowania.");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
