package sklep;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MaxCenaHandler extends DefaultHandler {
	private StringBuilder buf;
	double max = Double.NEGATIVE_INFINITY;

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
		if("cena".equals(qName)) {
			buf = new StringBuilder();
		}
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if("cena".equals(qName)) {
			double cena = Double.parseDouble(buf.toString());
			buf = null;
			if(cena > max) {
				max = cena;
			}
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if(buf != null)
			buf.append(ch, start, length);
	}

	public double max() {
		return max;
	}
}
