package sklep;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import util.Args;

public class Filtruj {

	public static void main(String[] args) {
		args = Args.argsOrDefault(args, "sklep.xml", "new_Filtruj.xml", "herbata");
		try {
			// Jeśli chcemy walidować, to można np. powielić to, co jest w ZnajdzMaxCene
			XMLReader reader = XMLReaderFactory.createXMLReader();
			
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer transformer = tf.newTransformer();
			
			FiltrKategorii filtr = new FiltrKategorii(args[2]);
			filtr.setParent(reader);
			
			InputSource wejscie = new InputSource(args[0]);
			SAXSource src = new SAXSource(filtr, wejscie);
			StreamResult res = new StreamResult(args[1]);
			transformer.transform(src, res);
			System.out.println("Gotowe");
			
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
