package sklep;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class FiltrKategorii extends XMLFilterImpl {
	private final String idKategorii;
	private boolean puszczac = true;
	
	public FiltrKategorii(String id) {
		idKategorii = id;
	}

	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes atts) throws SAXException {
		if("kategoria".equals(qName) || "towar".equals(qName)) {
			String biezacaKategoria = atts.getValue("id-kategorii");
			if(! idKategorii.equals(biezacaKategoria)) {
				puszczac = false;
			}
		}
		
		if(puszczac)
			super.startElement(uri, localName, qName, atts);
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		if(puszczac)
			super.endElement(uri, localName, qName);
		
		if("kategoria".equals(qName) || "towar".equals(qName)) {
			puszczac = true;
		}
	}

	@Override
	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if(puszczac)
			super.characters(ch, start, length);
	}
}
