package przyklady_z_uczelni.rooms;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import util.Args;

public class WypiszSaleXslt {

	public static void main(String[] args) {
		args = Args.argsOrDefault(args, "rooms.xml", "wypisz_sale.xsl", "wypisane_sale.txt");

		Source xsl = new StreamSource(args[1]);
		Source src = new StreamSource(args[0]);
		Result res = new StreamResult(args[2]);
		
		try {
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer t = tf.newTransformer(xsl);
			t.transform(src, res);
			System.out.println("Gotowe");
			
		} catch (TransformerConfigurationException e) {
			e.printStackTrace();
		} catch (TransformerFactoryConfigurationError e) {
			e.printStackTrace();
		} catch (TransformerException e) {
			e.printStackTrace();
		}

	}

}
