package przyklady_z_uczelni.rooms;

import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import przyklady_z_uczelni.rooms.jaxb_generated.Room;
import przyklady_z_uczelni.rooms.jaxb_generated.Rooms;
import util.Args;

public class CountSeats_JAXB {
	private int sum = 0;
	
	public static void main(String[] args) {
		args = Args.argsOrDefault(args, "rooms.xml");
		String input = args[0];
		try {
			CountSeats_JAXB program = new CountSeats_JAXB();
			int result = program.countSeats(input);
			System.out.println("Result: " + result);
		} catch (Exception e) {
			System.out.println("Exception! " + e.getMessage());
			e.printStackTrace();
		}
	}

	public int countSeats(String fileName) throws JAXBException {
		System.out.println("Starting with file " + fileName);
		JAXBContext jaxbContext = JAXBContext.newInstance(Rooms.class);
		Unmarshaller u = jaxbContext.createUnmarshaller();
		Rooms rooms = (Rooms) u.unmarshal(new File(fileName));
		if(rooms != null)
			this.processRooms(rooms);
		return sum;
	}

	private void processRooms(Rooms rooms) {
		for(Room room : rooms.getRoom()) {
			if(room.getEquipment().isProjector() && room.getSeats() != null) {
				// System.out.println(room.getNumber());
				sum += room.getSeats();
			}
		}
	}
}
