package przyklady_sax;

import javax.xml.XMLConstants;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import pomoce.MojBrutalnyErrorHandler;
import pomoce.MojErrorHandler;

public class SredniaCena_SAX {
	public static void main(String[] args) {
		if(args.length < 1) {
			System.out.println("Za malo argumentow. Podaj nazwe pliku.");
			return;
		}
		
		try {
			SredniaCenaHandler_Porzadniej mojHandler = new SredniaCenaHandler_Porzadniej();
			MojBrutalnyErrorHandler eh = new MojBrutalnyErrorHandler();
			
			SchemaFactory sf = SchemaFactory.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Schema schema = sf.newSchema(new StreamSource("sklep.xsd"));

			SAXParserFactory spf = SAXParserFactory.newInstance();
			spf.setSchema(schema);
			SAXParser parser = spf.newSAXParser();
			XMLReader reader = parser.getXMLReader();
			
			reader.setContentHandler(mojHandler);
			reader.setErrorHandler(eh);
			reader.parse(args[0]);
			System.out.println(mojHandler.wypisz());
			
		} catch (SAXException e) {
			System.out.println("Blad parsowania.");
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
