package przyklady.software;
/**Przyklad do artykulu "XML w Javie 5.0".
 * Przyklad uzycia pakietu javax.xml.transform.
 * 
 * Marzec 2005
 * @author Patryk Czarnik
 */

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import util.Args;

/**Program parsuje podany plik XML i zapisuje do podanego pliku.
 * Jesli podano trzeci parametr,dokument jest przeksztalcany zgodnie z podanym arkuszem XSLT.
 */
public class TransformExample {
  public static void main(String[] args) {
	args = Args.argsOrDefault(args, "sklep.xml", "new_TransformExample.xml");
    try {
      SAXParserFactory parser_fact = SAXParserFactory.newInstance();
      XMLReader parser = parser_fact.newSAXParser().getXMLReader();
      InputSource doc = new InputSource(args[0]);
      
      TransformerFactory trans_fact = TransformerFactory.newInstance();
      Transformer transformer;
      if(args.length >= 3)
         transformer = trans_fact.newTransformer(new StreamSource(args[2]));
      else
         transformer = trans_fact.newTransformer();

      System.out.println("Poczatek przeksztalcania.");

      Source src = new SAXSource(parser, doc);
      Result res = new StreamResult(args[1]);
      transformer.transform(src, res);

      System.out.println("Koniec przeksztalcania.");
    } catch (Exception e) {
      System.out.println(e.getMessage());
      e.printStackTrace();
    }
  }
}
