package przyklady.software;
/**Przykład nr 12 do artykułu "Alternatywne źródła SAX".
 * Parsowanie "na niby" obiektu w pamięci na przykładzie
 * obiektu ResultSet i parsera DBReader.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.InputSource;

/**Program wykonuje na określonej bazie danych zapytanie
 * podane na standardowym wejściu (w jednym wierszu).
 * Następnie czyta obiekt z wynikami tworząc zdarzenia SAX
 * obsługiwane przez obiekt Transformer, który zapisuje
 * wynikowy dokument XML do podanego pliku lub na
 * standardowe wyjście.
 * Jeśli podano parametr x, dokument jest przekształcany zgodnie z podanym arkuszem XSLT.
 * Musi być dostępny (w CLASSPATH) sterownik JDBC bazy danych, należy też
 * dostosować (w kodzie) sposób łączenia się z bazą.
 * Parametry:<ul>
 * <li> -h host bazy danych (jeśli nie podany to localhost),
 * <li> -n nazwa bazy danych,
 * <li> -u użytkownik bazy danych,
 * <li> -p hasło bazy danych,
 * <li> -o nazwa pliku wyjściowego, jeśli nie jest podana program wypisuje wynik na standardowe wyjście,
 * <li> -x nazwa pliku z arkuszem XSLT.
 * </ul>
 */
public class Sax12 {
  public static void main(String[] args) {
    System.out.println("Program Sax12 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_host = params.get("h");
    String param_name = params.get("n");
    String param_user = params.get("u");
    String param_passwd = params.get("p");
    String param_out = params.get("o");
    String param_xslt = params.get("x");
    if(param_host == null)
      param_host = "localhost";
    if(param_name == null)
      param_name = "";
    System.out.println("Podaj zapytanie:");
    try {
      Connection db = DriverManager.getConnection("jdbc:postgresql://" + param_host + "/" + param_name, param_user, param_passwd);
      // dla innych baz danych inaczej

      BufferedReader in_rd = new BufferedReader(new InputStreamReader(System.in));
      String query = in_rd.readLine();
      PreparedStatement stmt = db.prepareStatement(query);
      ResultSet result = stmt.executeQuery();
      
      DBReader parser = new DBReader();
      parser.setResultSet(result);

      TransformerFactory trans_fact = TransformerFactory.newInstance();
      Transformer transformer = param_xslt == null ? trans_fact.newTransformer() : trans_fact.newTransformer(new StreamSource(param_xslt));

      System.out.println("Poczatek sztucznego parsowania.");

      Source src = new SAXSource(parser, new InputSource());
      // drugi parametr (InputSource) będzie zignorowany przez parser,
      // ale musimy coś podać do obiektu Transformer
      
      Result res = param_out == null ? new StreamResult(System.out) : new StreamResult(param_out);
      transformer.transform(src, res);

      System.out.println("\nKoniec sztucznego parsowania.");
      
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax12 zakonczony.");
  }
}
