package przyklady.software;
/**Przykład nr 11 do artykułu "Alternatywne źródła SAX".
 * Parsowanie "na niby" obiektu w pamięci na przykładzie
 * obiektu Counter i parsera CounterReader.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/**Program parsuje podany plik XML lub standardowe wejście,
 * liczy w nim referencje i zapamiętuje wyniki w obiekcie Counter.
 * Następnie czyta obiekt z wynikami tworząc zdarzenia SAX
 * obsługiwane przez obiekt Transformemr, który zapisuje
 * wynikowy dokument XML do podanego pliku lub na
 * standardowe wyjście.
 * Parametry:<ul>
 * <li> -i nazwa pliku źródłowego, jeśli nie jest podana program parsuje standardowe wejście.
 * <li> -o nazwa pliku wyjściowego, jeśli nie jest podana program wypisuje wynik na standardowe wyjście,
 * </ul>
 */
public class Sax11 {
  public static void main(String[] args) {
    System.out.println("Program Sax11 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_src = params.get("i");
    String param_out = params.get("o");
    try {
      SAXParserFactory parser_fact = SAXParserFactory.newInstance();
      XMLReader parser = parser_fact.newSAXParser().getXMLReader();
      InputSource doc = param_src == null ? new InputSource(System.in) : new InputSource(param_src);
      
      CountingHandler handler = new CountingHandler();
      parser.setContentHandler(handler);
      System.out.println("Poczatek parsowania.");
      parser.parse(doc);
      System.out.println("Koniec parsowania. Wynik jest w pamieci.");

      Counter cnt = handler.getCounter();
      // Mamy wynik w ręce
      
      CounterReader parser1 = new CounterReader(cnt);

      TransformerFactory trans_fact = TransformerFactory.newInstance();
      Transformer transformer = trans_fact.newTransformer();  // tylko serializuje

      System.out.println("Poczatek sztucznego parsowania.");

      Source src = new SAXSource(parser1, new InputSource());
      // drugi parametr (InputSource) będzie zignorowany przez parser,
      // ale musimy coś podać do obiektu Transformer
      
      Result res = param_out == null ? new StreamResult(System.out) : new StreamResult(param_out);
      transformer.transform(src, res);

      System.out.println("\nKoniec sztucznego parsowania.");
      
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax11 zakonczony.");
  }
}
