package przyklady.software;
/**Przykład nr 9 do artykułu "Alternatywne źródła SAX".
 * Zastosowanie parsera TxtReader w połączeniu z filtrem
 * CategoryFilter i obiektem CountingHandler.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/**Program parsuje podany plik tekstowy lub standardowe wejście, filtruje
 * wpisy i liczy w nich referencje, a następnie wypisuje wyniki
 * na standardowe wyjście.
 * Parametry:<ul>
 * <li> -i nazwa pliku źródłowego, jeśli nie jest podana program parsuje standardowe wejście,
 * <li> -k wybrana kategoria.
 * </ul>
 */
public class Sax09 {
  public static void main(String[] args) {
    System.out.println("Program Sax09 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_src = params.get("i");
    String param_cat = params.get("k");
    try {
      XMLReader parser = new TxtReader();
      InputSource doc = param_src == null ? new InputSource(System.in) : new InputSource(param_src);
      
      CategoryFilter cat_filter = new CategoryFilter();
      if(param_cat != null)
        cat_filter.addCategory(param_cat);
      cat_filter.setParent(parser);
      
      CountingHandler handler = new CountingHandler();
      cat_filter.setContentHandler(handler);
      System.out.println("Poczatek parsowania.");
      cat_filter.parse(doc);
      System.out.println("Koniec parsowania.");

      Counter cnt = handler.getCounter();
      System.out.println("Dokument zawieral nastepujace referencje:");
      System.out.println(cnt);
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax09 zakonczony.");
  }
}
