package przyklady.software;
/**Przykład nr 8 do artykułu "Alternatywne źródła SAX".
 * Zastosowanie parsera TxtReader i obiektu Transformer do zamiany
 * dokumentu z formatu tekstowego na XML.
 *  
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/**Program parsuje encyklopedię w formacie tekstowym z podanego pliku
 * lub standardowego wejścia i zapisuje w formacie XML do podanego pliku
 * lub na standardowe wyjście.
 * Jeśli podano parametr x, dokument jest przekształcany zgodnie
 * z podanym arkuszem XSLT.
 * Parametry:<ul>
 * <li> -i nazwa pliku źródłowego, jeśli nie jest podana program parsuje standardowe wejście,
 * <li> -o nazwa pliku wyjściowego, jeśli nie jest podana program wypisuje wynik na standardowe wyjście,
 * <li> -x nazwa pliku z arkuszem XSLT.
 * </ul>
 */
public class Sax08 {
  public static void main(String[] args) {
    System.out.println("Program Sax08 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_src = params.get("i");
    String param_out = params.get("o");
    String param_xslt = params.get("x");
    try {
      XMLReader parser = new TxtReader();
      InputSource doc = param_src == null ? new InputSource(System.in) : new InputSource(param_src);
      
      TransformerFactory trans_fact = TransformerFactory.newInstance();
      Transformer transformer = param_xslt == null ? trans_fact.newTransformer() : trans_fact.newTransformer(new StreamSource(param_xslt));

      System.out.println("Poczatek przeksztalcania.");

      Source src = new SAXSource(parser, doc);
      Result res = param_out == null ? new StreamResult(System.out) : new StreamResult(param_out);
      transformer.transform(src, res);

      System.out.println("Koniec przeksztalcania.");
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax08 zakonczony.");
  }
}
