package przyklady.software;
/**Przykład nr 5 do artykułu "Alternatywne źródła SAX".
 * Użycie filtra CategoryFilter w połączeniu z obiektem CountingHandler.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/**Program parsuje podany plik XML lub standardowe wejście,
 * filtruje wpisy należące do określonej kategorii i liczy
 * w nich referencje, po czym wypisuje wyniki na standardowe wyjście.
 * Parametry:<ul>
 * <li> -i nazwa pliku źródłowego, jeśli nie jest podana program parsuje standardowe wejście,
 * <li> -k wybrana kategoria, jeśli brak, to żadne wpisy nie są przepuszczane.
 * </ul>
 */
public class Sax05 {
  public static void main(String[] args) {
    System.out.println("Program Sax05 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_src = params.get("i");
    String param_cat = params.get("k");
    try {
      SAXParserFactory parser_fact = SAXParserFactory.newInstance();
      XMLReader parser = parser_fact.newSAXParser().getXMLReader();
      InputSource doc = param_src == null ? new InputSource(System.in) : new InputSource(param_src);
      
      CategoryFilter cat_filter = new CategoryFilter();
      if(param_cat != null)
        cat_filter.addCategory(param_cat);
      cat_filter.setParent(parser);
      
      CountingHandler handler = new CountingHandler();
      cat_filter.setContentHandler(handler);
      System.out.println("Poczatek parsowania.");
      cat_filter.parse(doc);
      System.out.println("Koniec parsowania.");

      Counter cnt = handler.getCounter();
      System.out.println("Dokument zawieral nastepujace referencje:");
      System.out.println(cnt);
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax05 zakonczony.");
  }
}
