package przyklady.software;
/**Przykład nr 3 do artykułu "Alternatywne źródła SAX".
 * Prezentacja użycia klasy Transformer do serializacji strumienia SAX
 * i opcjonalnie do przekształcenia XSLT.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/**Program parsuje podany plik XML lub standardowe wejście i zapisuje
 * do podanego pliku lub na standardowe wyjście. Jeśli podano parametr x,
 * dokument jest przekształcany zgodnie z podanym arkuszem XSLT.
 * Parametry:<ul>
 * <li> -i nazwa pliku źródłowego, jeśli nie jest podana program parsuje standardowe wejście,
 * <li> -o nazwa pliku wyjściowego, jeśli nie jest podana program wypisuje wynik na standardowe wyjście,
 * <li> -x nazwa pliku z arkuszem XSLT.
 * </ul>
 */
public class Sax03 {
  public static void main(String[] args) {
    System.out.println("Program Sax03 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_src = params.get("i");
    String param_out = params.get("o");
    String param_xslt = params.get("x");
    try {
      SAXParserFactory parser_fact = SAXParserFactory.newInstance();
      XMLReader parser = parser_fact.newSAXParser().getXMLReader();
      InputSource doc = param_src == null ? new InputSource(System.in) : new InputSource(param_src);
      
      TransformerFactory trans_fact = TransformerFactory.newInstance();
      Transformer transformer = param_xslt == null ? trans_fact.newTransformer() : trans_fact.newTransformer(new StreamSource(param_xslt));

      System.out.println("Poczatek przeksztalcania.");

      Source src = new SAXSource(parser, doc);
      Result res = param_out == null ? new StreamResult(System.out) : new StreamResult(param_out);
      transformer.transform(src, res);

      System.out.println("Koniec przeksztalcania.");
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax03 zakonczony.");
  }
}
