package przyklady.software;
/**Przykład nr 2 do artykułu "Alternatywne źródła SAX".
 * Standardowe wykorzystanie standardu SAX do parsowania pliku XML.
 * Obiekt parsera pobierany jest w inny sposób niż w Sax01.
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/**Program parsuje podany plik XML lub standardowe wejście i liczy referencje,
 * po czym wypisuje wyniki na standardowe wyjście.
 * Parametry:<ul>
 * <li> -i nazwa pliku źródłowego, jeśli nie jest podana program parsuje standardowe wejście.
 * </ul>
 */
public class Sax02 {
  public static void main(String[] args) {
    System.out.println("Program Sax02 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_src = params.get("i");
    try {
      //System.setProperty("org.xml.sax.driver", "org.apache.crimson.parser.XMLReaderImpl");
      XMLReader parser = XMLReaderFactory.createXMLReader();

      InputSource doc = param_src == null ? new InputSource(System.in) : new InputSource(param_src);

      CountingHandler handler = new CountingHandler();
      parser.setContentHandler(handler);
      System.out.println("Poczatek parsowania.");
      parser.parse(doc);
      System.out.println("Koniec parsowania.");

      Counter cnt = handler.getCounter();
      System.out.println("Dokument zawieral nastepujace referencje:");
      System.out.println(cnt);
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax02 zakonczony.");
  }
}
