package przyklady.software;
/**Przykład nr 1 do artykułu "Alternatywne źródła SAX".
 * Standardowe wykorzystanie standardu SAX do parsowania pliku XML.
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;


/**Program parsuje podany plik XML lub standardowe wejście i liczy referencje,
 * po czym wypisuje wyniki na standardowe wyjście.
 * Parametry:<ul>
 * <li> -i nazwa pliku źródłowego, jeśli nie jest podana program parsuje standardowe wejście.
 * </ul>
 */
public class Sax01 {
  public static void main(String[] args) {
    System.out.println("Program Sax01 uruchomiony.");
    System.out.println();
    ProgramParams params = new ProgramParams(args);
    String param_src = params.get("i");
    try {
      SAXParserFactory parser_fact = SAXParserFactory.newInstance();
      XMLReader parser = parser_fact.newSAXParser().getXMLReader();
      InputSource doc = param_src == null ? new InputSource(System.in) : new InputSource(param_src);

      CountingHandler handler = new CountingHandler();
      parser.setContentHandler(handler);
      System.out.println("Poczatek parsowania.");
      parser.parse(doc);
      System.out.println("Koniec parsowania.");

      Counter cnt = handler.getCounter();
      System.out.println("Dokument zawieral nastepujace referencje:");
      System.out.println(cnt);
    } catch (Exception e) {
      System.out.println("Wyjatek: "+e.getMessage());
      e.printStackTrace();
    }
    System.out.println();
    System.out.println("Program Sax01 zakonczony.");
  }
}
