package przyklady.software;
/**Przykład do artykułu "Alternatywne źródła SAX".
 * Obsługa parametrów programu.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import java.util.HashMap;
import java.util.Map;

/**Klasa odczytuje parametry programu
 * (podawane zgodnie z konwencją -nazwa wartość).
 * @author Patryk Czarnik
 */
public class ProgramParams {
  public ProgramParams(String[] aParams) {
    super();
    fMap = new HashMap();
    for(int i=0; i<aParams.length; i++) {
      if(aParams[i].startsWith("-")) {
        String name = aParams[i].substring(1);
        String value = "";
        if(i < aParams.length - 1 && !aParams[i+1].startsWith("-")) {
          i++;
          value = aParams[i]; 
        }
        fMap.put(name, value);
      }
    }
  }
  
  public String get(String aName) {
    return (String)fMap.get(aName);
  }
  
  private Map fMap;
}
