package przyklady.software;
/**Przykład do artykułu "Alternatywne źródła SAX".
 * ContentHandler liczący referencje i tworzący obiekt Counter z wynikami.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**Klasa obsługuje zdarzenia SAX, zakłada że dokument
 * jest zgodny ze strukturą encyklopedia.dtd.
 * Liczy referencje do poszczególnych haseł.
 * @author Patryk Czarnik
 */
public class CountingHandler extends DefaultHandler {
  public CountingHandler() {
	fCounter = new Counter();
  }

  /** Zwraca wynik (powinna być wywołana po parsowaniu). */
  public Counter getCounter() {
    return fCounter;
  }

  // Metody SAX:

  /**Metoda wywoływana na początku elementu.
   * Element ref występuje tylko w tym kontekście, który nas interesuje.
   */
  public void startElement(String aURI, String aLocal, String aQName, Attributes aAttrs)
  throws SAXException {
    if(aQName.equals("ref")) {
      fCounter.add(aAttrs.getValue("haslo"));
    }
  }

  private Counter fCounter;
}
