package przyklady.software;
/**Przykład do artykułu "Alternatywne źródła SAX".
 * "Sztuczny" parser SAX czytający obiekty Counter.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import java.io.IOException;
import java.util.Iterator;
import java.util.Map.Entry;

import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

/** "Sztuczny" parser SAX, tworzący zdarzenia SAX
 * reprezentujące dokument zgodny z wyniki.dtd
 * na podstawie obiektu Counter.
 * 
 * @author Patryk Czarnik
 */
public class CounterReader implements XMLReader {
  /** Tworzy parser czytający dane z okreslonego obiektu. */
  public CounterReader(Counter aCounter) {
    fCounter = aCounter;
  }

  /** Tworzy zdarzenia SAX reprezentujące dokument wynikowy
   * i wysyła je do obiektu okreslonego wcześniej przez setContentHandler.
   */
  public void parse(String aSystemId) throws IOException, SAXException {
    if(fHandler != null) {
      Iterator val_iter = fCounter.getValues().entrySet().iterator();
      AttributesImpl attrs = new AttributesImpl();
      
      fHandler.startDocument();
      fHandler.startElement("", "wyniki", "wyniki", attrs);
      
      while(val_iter.hasNext()) {
        Entry entry = (Entry)val_iter.next();
        String word = (String)entry.getKey();
        Integer count = (Integer)entry.getValue();
        
        attrs.addAttribute("", "haslo", "haslo", "CDATA", word);
        attrs.addAttribute("", "liczba", "liczba", "CDATA", count.toString());
        fHandler.startElement("", "wynik", "wynik", attrs);
        fHandler.endElement("", "wynik", "wynik");
        attrs.clear();
      }
      
      fHandler.endElement("", "wyniki", "wyniki");
      fHandler.endDocument();
    }
  }

  public void parse(InputSource aInput) throws IOException, SAXException {
    this.parse("");
  }

  public ContentHandler getContentHandler() {
    return fHandler;
  }
  /**Ustawia obiekt, do którego będą wysyłane zdarzenia SAX
   * podczas parsowania.
   */
  public void setContentHandler(ContentHandler aHandler) {
    fHandler = aHandler;
  }

  // Nie implementowane:
  public DTDHandler getDTDHandler() {
    return null;
  }
  public void setDTDHandler(DTDHandler handler) {
  }
  public EntityResolver getEntityResolver() {
    return null;
  }
  public void setEntityResolver(EntityResolver resolver) {
  }
  public ErrorHandler getErrorHandler() {
    return null;
  }
  public void setErrorHandler(ErrorHandler handler) {
  }
  public boolean getFeature(String name) throws SAXNotRecognizedException,
  SAXNotSupportedException {
    return false;
  }
  public void setFeature(String name, boolean value)
  	throws SAXNotRecognizedException, SAXNotSupportedException {
  }
  public Object getProperty(String name) throws SAXNotRecognizedException,
      SAXNotSupportedException {
    return null;
  }
  public void setProperty(String name, Object value)
      throws SAXNotRecognizedException, SAXNotSupportedException {
  }
  
  private Counter fCounter;
  private ContentHandler fHandler;
}
