package przyklady.software;
/**Przykład do artykułu "Alternatywne źródła SAX".
 * Licznik referencji.
 * 
 * Kwiecień 2004.
 * @author Patryk Czarnik
 */

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TreeMap;

/**Klasa pozwala liczyć ile razy występują poszczególne napisy.
 * @author Patryk Czarnik
 */
public class Counter {
  public Counter() {
    super();
    fMap = new TreeMap();
  }

  /** Dodaje jedno wystąpienie napisu aKey. */
  public void add(String aKey) {
    Integer val = (Integer)fMap.get(aKey);
    if(val == null) {
      val = new Integer(1);
    } else {
      val = new Integer(val.intValue()+1);
    }
    fMap.put(aKey, val);
  }
  
  /** Zwraca słownik, którego klucze to napisy,
   * a wartości to liczby ich wystąpień (jako obiekty Integer). */
  public Map getValues() {
    return fMap;
  }
  
  /** Tworzy napis - prostą reprezentację wartości. */
  public String toString() {
    String result = new String();
    Iterator iter = fMap.entrySet().iterator();
    while(iter.hasNext()) {
      Entry entry = (Entry)iter.next();
      result += (String)entry.getKey() + "  --  " + (Integer)entry.getValue() + "\n";
    }
    return result;
  }
  
  private Map fMap;
}
