<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:param name="kategoria"/>
	<xsl:output method="html" encoding="utf-8"/>
	
	<xsl:decimal-format
		decimal-separator=","
		grouping-separator=" "/>

	<!-- Szablon dla korzenia, uruchamiany jako pierwszy -->
	<xsl:template match="/">
		<html>
			<head>
				<title>Sklep <xsl:value-of select="$kategoria"/></title>
				<style type="text/css">
					body { background-color: #DDDDDD}
					.kat {background-color: #DDFFFF}
					.tow { background-color: #FFFFDD}
					.tow, .kat {
						border: 2px outset #665500;
						margin: 1em auto;
						padding: 0.5em;
						width: 400px;
					}
					h2 {
						margin: 0 0 0.5em 0;
					}
					strong { color: red }
				</style>
			</head>
			<body>
				<xsl:apply-templates select="(sklep/kategoria | sklep/towar)
						[@id-kategorii = $kategoria or not($kategoria)]"/>
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="kategoria">
		<div class="kat" id="K{@id-kategorii}">
			<xsl:apply-templates select="nazwa"/>
			<xsl:apply-templates select="opis"/>

			<xsl:for-each select="//towar[@id-kategorii = current()/@id-kategorii]">
				<a href="#T{@id-towaru}">
				<xsl:value-of select="nazwa"/>
				</a>
				<xsl:if test="position() != last()">, </xsl:if>
			</xsl:for-each>
		</div>
	</xsl:template>
	
	<xsl:template match="towar">
		<div class="tow" id="T{@id-towaru}">
				<!-- Sami nadajemy kolejność wypisywanym elementom -->
			<xsl:apply-templates select="nazwa"/>

			<xsl:variable name="moja-kategoria" select="@id-kategorii"/>
			<a href="#K{@id-kategorii}">
				<xsl:value-of select="//kategoria[@id-kategorii = $moja-kategoria]/nazwa"/>
			</a>
			
			<!-- Albo bez zmiennej:
			<xsl:value-of select="//kategoria[@id-kategorii = current()/@id-kategorii]/nazwa"/> -->

			<br/>
			Cena netto: 
			<xsl:call-template name="kwota">
				<xsl:with-param name="wartość" select="cena"/>
			</xsl:call-template>
			<br />

			Cena brutto:
			<xsl:call-template name="kwota">
				<xsl:with-param name="wartość" select="cena * (1 + vat div 100)"/>
			</xsl:call-template>
		
			<xsl:apply-templates select="opis"/>
		</div>
	</xsl:template>
	
	<xsl:template match="nazwa">
		<h2><xsl:apply-templates/></h2>
	</xsl:template>
	
	<xsl:template match="opis">
		<p><xsl:apply-templates/></p>
	</xsl:template>
	
	<xsl:template match="em">
		<strong><xsl:apply-templates/></strong>
	</xsl:template>
		
	<xsl:template match="term">
		<dfn><xsl:apply-templates/></dfn>
	</xsl:template>
	
	<xsl:template match="link">
		<a href="{@href}"><xsl:apply-templates/></a>
	</xsl:template>
	
	<xsl:template match="br">
		<br/>
	</xsl:template>
	
	<xsl:template name="kwota">
		<xsl:param name="wartość"/>
		
		<xsl:value-of select="format-number($wartość, '0,00')"/>
	</xsl:template>
	
</xsl:stylesheet>
