package com.example;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class KontoTest {
    static final String osoba = "Ala", osoba2 = "Ola";
    Konto konto;
    
    @BeforeEach
    void setUp() throws Exception {
        konto = new Konto(1, 1000, osoba);
    }

    @Test
    void testKonstruktorIGettery() {
            assertEquals(1, konto.getNumer());
            assertEquals(osoba, konto.getWlasciciel());
            assertEquals(1000, konto.getSaldo());
    }

    @Test
    void testToString() {
            String napis = konto.toString();
            assertEquals("Konto nr 1, saldo 1000, wł. "+osoba.toString(), napis);
    }
    
    @Test
    void testWplata() {
        konto.wplata(400);
        assertEquals(1400, konto.getSaldo());
    }

    @Test
    void testWyplata() throws BrakSrodkow {
        konto.wyplata(300);
        assertEquals(700, konto.getSaldo());
    }

    @Test
    void testWplataUjemna() {
        assertThrows(IllegalArgumentException.class, () -> {
            konto.wplata(-100);
        });
        assertEquals(1000, konto.getSaldo());
    }
    
    @Test
    void testWyplataUjemna() {
        assertThrows(IllegalArgumentException.class, () -> {
            konto.wyplata(-100);            
        });
        assertEquals(1000, konto.getSaldo());
    }
    
    @Test
    void testBrakSrodkow() {
        assertThrows(BrakSrodkow.class, () -> {
            konto.wyplata(1300);            
        });
        assertEquals(1000, konto.getSaldo());
    }
    
    @Test
    void testPrzelew() throws BrakSrodkow {
        Konto inne = new Konto(2, 2000, osoba2);
        konto.przelew(inne, 400);
        assertEquals(600, konto.getSaldo());
        assertEquals(2400, inne.getSaldo());
    }
    
    @Test
    void testPrzelewUjemny() {
        Konto inne = new Konto(2, 2000, osoba2);
        assertThrows(IllegalArgumentException.class, () -> {
            konto.przelew(inne, -100);            
        });
        assertEquals(1000, konto.getSaldo());
        assertEquals(2000, inne.getSaldo());
    }
}
