package com.example;

public class Konto {
    private final int numer;
    private int saldo;
    private String wlasciciel;

    public Konto(int numer, int saldo, String wlasciciel) {
        if(saldo < 0) {
            throw new IllegalArgumentException("ujemne saldo!");
        }
        this.numer = numer;
        this.saldo = saldo;
        this.wlasciciel = wlasciciel;
    }

    public int getNumer() {
        return numer;
    }

    public int getSaldo() {
        return saldo;
    }

    public String getWlasciciel() {
        return wlasciciel;
    }

    public void setWlasciciel(String wlasciciel) {
        this.wlasciciel = wlasciciel;
    }

    @Override
    public String toString() {
        return "Konto nr " + numer + ", saldo " + saldo + ", wł. " + wlasciciel;
    }

    public void wplata(int kwota) {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota wpłaty nie jest dodatnia");
        }
        saldo += kwota;
    }

    public void wyplata(int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota wypłaty nie jest dodatnia");
        }
        if(kwota > saldo) {
            throw new BrakSrodkow("Za mało kasy");
        }
        saldo -= kwota;
    }
    
    public void przelew(Konto inne, int kwota) throws BrakSrodkow {
        if(kwota <= 0) {
            throw new IllegalArgumentException("kwota przelewu nie jest dodatnia");
        }
        if(kwota > saldo) {
            throw new BrakSrodkow("Za mało kasy");
        }
        this.saldo -= kwota;
        inne.saldo += kwota;
    }
}
