from django.http import HttpRequest, HttpResponse
from django.shortcuts import render

from datetime import datetime

# Create your views here.
def index(request:HttpRequest) -> HttpResponse:
    return render(request, 'index.html')

def hello(request):
    return HttpResponse('Hello world')

def podaj_czas(request):
    dt = datetime.now()
    return HttpResponse(dt, content_type='text/plain;charset=UTF-8')

# prosty sposób, aby zwrócić treść w formacie HTML
# po prostu tworzymy HTML w funkcji Pythona i wstawiamy do HttpResponse
def czas_html(request:HttpRequest) -> HttpResponse:
    godzina = datetime.now().strftime('%H:%M:%S')
    html = f'''<html><head>
<title>Która godzina</title>
</head>
<body style="background-color: #FFFFDD">
<p>Teraz jest późna godzina <strong style="color:purple">{godzina}</strong></p>
</body>
</html>
'''
    return HttpResponse(html, content_type='text/html;charset=UTF-8')

# Bardziej profesjonalnym sposobem tworzenia treści HTML jest używanie szablonów (template)
# czyli zewnętrznych plików, które zawierają treść do wysłania, ale pozwalają także
# wstawić wartości pochodzące z aplikacji.
def czas_szablon(request:HttpRequest) -> HttpResponse:
    data_i_czas = datetime.now()
    data = data_i_czas.strftime('%Y-%m-%d')
    czas = data_i_czas.strftime('%H:%M:%S')
    fmt = data_i_czas.strftime('%d.%m.%Y %H:%M')
    return render(request, 'wyswietl_czas.html',
                  context={'dt': data_i_czas,
                           'data': data,
                           'czas': czas,
                           'fmt': fmt,
                           'wynik': 2+3})


def rozmowa(request:HttpRequest) -> HttpResponse:
    powitanie = 'Hej, może się przedstawisz?'
    try:
        imie = request.GET['imie']
        if imie:
            powitanie = f'Witaj {imie}'
    except KeyError:
        pass

    return render(request, 'rozmowa.html',
                  context={'message': powitanie})


def oblicz(arg1, arg2, operacja):
    match operacja:
        case '+': return arg1 + arg2
        case '-': return arg1 - arg2
        case '*': return arg1 * arg2
        case '/': return arg1 / arg2
        case '%': return arg1 % arg2
        case '^': return arg1 ** arg2
        case _: raise ValueError(f'Nieznana operacja {operacja}')

def kalkulator(request:HttpRequest) -> HttpResponse:
    wynik = 1313
    try:
        arg1 = int(request.GET['arg1'])
        arg2 = int(request.GET['arg2'])
        operacja = request.GET['operacja']
        wynik = oblicz(arg1, arg2, operacja)
    except Exception:
        pass
    return render(request, 'kalkulator.html',
                  context={'wynik': wynik})

dzialania = {
    'add': ('+', lambda x,y: x + y),
    'sub': ('-', lambda x,y: x - y),
    'mul': ('×', lambda x,y: x * y),
    'div': ('÷', lambda x,y: x // y),
    'mod': ('mod', lambda x,y: x % y),
    'pow': ('^', lambda x,y: x ** y),
}

def kalkulator_post(request: HttpRequest) -> HttpResponse:
    # W obiekcie request zapisane są wszelkie dane, który przyszły w zapytaniu,
    # w tym parametry zapytania. Aby wygodniej nam się z tego korzystało, do nagłówka funkcji dopisujemy type hints.

    # Ten słownik zawiera wszystkie informacje przekazane do szablonu.
    # W tej wersji buduję go stopniowo, w zależności od tego, co dzieje się w funkcji
    kontekst = {}

    # Jeśli zapytanie zawiera dane z formularza, to wyliczamy wynik.
    if 'operacja' in request.POST and 'liczba1' in request.POST and 'liczba2' in request.POST:
        try:
            liczba1 = int(request.POST['liczba1'])
            liczba2 = int(request.POST['liczba2'])
            op = request.POST['operacja']
            znak, funkcja = dzialania[op]
            kontekst['wynik'] = funkcja(liczba1, liczba2)
            kontekst['znak'] = znak
        except KeyError as e:
            kontekst['error'] = 'nieznane działanie'
        except Exception as e:
            kontekst['error'] = str(e)

    return render(request=request,
                  template_name='kalkulator_post.html',
                  context=kontekst)


