from django.http import HttpResponse
from django.shortcuts import render

from datetime import datetime

# Create your views here.

def hello(request):
    return HttpResponse('Hello world')

def podaj_czas(request):
    dt = datetime.now()
    return HttpResponse(dt, content_type='text/plain;charset=UTF-8')

# prosty sposób, aby zwrócić treść w formacie HTML
# po prostu tworzymy HTML w funkcji Pythona i wstawiamy do HttpResponse
def czas_html(request):
    godzina = datetime.now().strftime('%H:%M:%S')
    html = f'''<html><head>
<title>Która godzina</title>
</head>
<body style="background-color: #FFFFDD">
<p>Teraz jest późna godzina <strong style="color:purple">{godzina}</strong></p>
</body>
</html>
'''
    return HttpResponse(html, content_type='text/html;charset=UTF-8')
