from django.http import HttpRequest, HttpResponse
from django.shortcuts import render

from datetime import datetime

# Create your views here.
def index(request:HttpRequest) -> HttpResponse:
    return render(request, 'index.html')

def hello(request):
    return HttpResponse('Hello world')

def podaj_czas(request):
    dt = datetime.now()
    return HttpResponse(dt, content_type='text/plain;charset=UTF-8')

# prosty sposób, aby zwrócić treść w formacie HTML
# po prostu tworzymy HTML w funkcji Pythona i wstawiamy do HttpResponse
def czas_html(request:HttpRequest) -> HttpResponse:
    godzina = datetime.now().strftime('%H:%M:%S')
    html = f'''<html><head>
<title>Która godzina</title>
</head>
<body style="background-color: #FFFFDD">
<p>Teraz jest późna godzina <strong style="color:purple">{godzina}</strong></p>
</body>
</html>
'''
    return HttpResponse(html, content_type='text/html;charset=UTF-8')

# Bardziej profesjonalnym sposobem tworzenia treści HTML jest używanie szablonów (template)
# czyli zewnętrznych plików, które zawierają treść do wysłania, ale pozwalają także
# wstawić wartości pochodzące z aplikacji.
def czas_szablon(request:HttpRequest) -> HttpResponse:
    data_i_czas = datetime.now()
    data = data_i_czas.strftime('%Y-%m-%d')
    czas = data_i_czas.strftime('%H:%M:%S')
    fmt = data_i_czas.strftime('%d.%m.%Y %H:%M')
    return render(request, 'wyswietl_czas.html',
                  context={'dt': data_i_czas,
                           'data': data,
                           'czas': czas,
                           'fmt': fmt,
                           'wynik': 2+3})


def rozmowa(request:HttpRequest) -> HttpResponse:
    powitanie = 'Hej, może się przedstawisz?'
    try:
        imie = request.GET['imie']
        if imie:
            powitanie = f'Witaj {imie}'
    except KeyError:
        pass

    return render(request, 'rozmowa.html',
                  context={'message': powitanie})


def oblicz(arg1, arg2, operacja):
    match operacja:
        case '+': return arg1 + arg2
        case '-': return arg1 - arg2
        case '*': return arg1 * arg2
        case '/': return arg1 / arg2
        case '%': return arg1 % arg2
        case '^': return arg1 ** arg2
        case _: raise ValueError(f'Nieznana operacja {operacja}')

def kalkulator(request:HttpRequest) -> HttpResponse:
    wynik = 1313
    try:
        arg1 = int(request.GET['arg1'])
        arg2 = int(request.GET['arg2'])
        operacja = request.GET['operacja']
        wynik = oblicz(arg1, arg2, operacja)
    except Exception:
        pass
    return render(request, 'kalkulator.html',
                  context={'wynik': wynik})