package p13_pliki.podstawy;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalTime;

public class Zapis5 {
	// W tej wersji programu zamykamy plik w sekcji finally - tak robiła się przed Java 7.
	// Jednocześnie obsługę błędu FileNotFound przenosimy do catch - to jest najbardziej typowy zapis.
	
	public static void main(String[] args) {
		LocalTime czas = LocalTime.now();
		System.out.println("Startujemy o godzinie " + czas);
		int cyfra = czas.getSecond() % 10;
		System.out.println("Ostatnia cyfra sekundy: " + cyfra);

		PrintWriter out = null;
		try {
			out = new PrintWriter("wynik5.txt");
			out.println("Pierwsza linia");
			out.println("Druga linia");
			out.print("Teraz jest godzina ");
			out.println(czas);
			out.println("Wynik dzielenia: " + (100 / cyfra));
			out.println("Koniec");
		} catch(FileNotFoundException e) {
			e.printStackTrace();
		} finally {
			if(out != null)
				out.close();
		}
		System.out.println("Gotowe");
	}

}
