package p13_pliki.podstawy;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.time.LocalTime;

public class Zapis4 {
	// W tej wersji stosujemy konstrukcję try-with-resources (od Java 7),
	// która gwarantuje, że plik zostanie zamknięty podczas wychodzenia z bloku try w każdej w tych sytuacji:
	// - gdy blok try normalnie się wykona
	// - gdy dojdzie do wyjątku, który zostanie obsłużony w catch
	// - gdy dojdzie wyjątku, które nie jest wyłapany
	// - gdy wewnątrz try znajdzie się instrukcja return albo inna przerywająca działanie (ale nie System.exit() !)
	
	public static void main(String[] args) {
		LocalTime czas = LocalTime.now();
		System.out.println("Startujemy o godzinie " + czas);
		int cyfra = czas.getSecond() % 10;
		System.out.println("Ostatnia cyfra sekundy: " + cyfra);

		// możesz spróbować zapisać nowy plik na pulpicie albo w podobnym miejscu
		// na komputerze w sali ALX byłoby tak:
		// "C:/Users/kurs/Desktop/nowy_plik.txt"
		// "C:\\Users\\kurs\\Desktop\\nowy_plik.txt"
		// UWAGA - to nadpisuje instniejące pliki
		
		try(PrintWriter out = new PrintWriter("wynik4.txt")) {
			out.println("Pierwsza linia");
			out.println("Druga linia");
			out.print("Teraz jest godzina ");
			out.println(czas);
			out.println("Wynik dzielenia: " + (100 / cyfra));
			out.println("Koniec");
			// gdy używamy try-with-resources, nie trzeba już jawnie pisać close
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
		System.out.println("Gotowe");
	}

}
