package p11_klasy.podstawy_v6;

import java.util.HashSet;
import java.util.Set;

public class Porownywanie {

	public static void main(String[] args) {
		Osoba a = new Osoba("Ala", "Kowalska", 30);
		Osoba b = new Osoba("Ola", "Malinowska", 30);
		Osoba c = new Osoba("Ala", "Kowalska", 30);
		Osoba r = a;
		
		System.out.println("\nWszystkie obiekty:");
		System.out.println("a: " + a);
		System.out.println("b: " + b);
		System.out.println("c: " + c);
		System.out.println("r: " + r);

		// operator == sprawdza "czy to jest ten sam obiekt"
		// porównywane są adresy, a nie zawartość obiektów
		System.out.println("\nPorównanie ==:");
		System.out.println("a == a: " + (a == a));
		System.out.println("a == b: " + (a == b));
		System.out.println("a == c: " + (a == c));
		System.out.println("a == r: " + (a == r));
		
		// Metoda equals ma służyć do logicznego porównywania obiektów.
		// Bardzo często działa tak, że sprawdza, czy zawartość obiektów jest równa (np. tak jest dla Stringów)
		// Ale dla własnej klasy TO AUTOR KLASY MUSI ZDEFINIOWAĆ metodę equals,
		// aby działała w taki sposób. Domyślnie equals działa tak samo jak ==
		System.out.println("\nPorównanie eq:");
		System.out.println("a eq a: " + a.equals(a));
		System.out.println("a eq b: " + a.equals(b));
		System.out.println("a eq c: " + a.equals(c));
		System.out.println("a eq r: " + a.equals(r));
		
		// Metoda hashCode zwraca liczbę int na podstawie obiektu.
		// Domyślnie jest to liczba uzyskiwana na podstawie adresu; taka, aby była unikalna w skali maszyny wirtualnej
		
		// Autor klasy może zmienić definicję hashCode i POWINIEN TO ZROBIĆ jeśli definiuje equals
		// Jeśli obiekty są równe w sensie equals, to hasz kody muszą być równe
		// Jeśli obiekty są różne (equals daje false), to haszkody z dużym prawdopodobieństwem powinny być różne.
		// Zazwyczaj własny hashCode jest jakąś formą sumy kontrolnej wyliczaj na podstawie wartości pól.
		System.out.println("\nHasz kody:");
		System.out.println("a: " + a.hashCode());
		System.out.println("b: " + b.hashCode());
		System.out.println("c: " + c.hashCode());
		System.out.println("r: " + r.hashCode());
		System.out.println();
		
		Set<Osoba> set = new HashSet<>();
		set.add(a);
		set.add(b);
		set.add(c);
		set.add(r);
		System.out.println("Rozmiar zbioru: " + set.size());
		System.out.println(set);
	}

}
