package p11_klasy.podstawy_v5;

import java.util.Objects;

public class Osoba {
	// Zmienna deklarowana na poziomie klasy to jest:
	// pole (field), atrybut (attribute), zmienna instancyjna (instance variable)
	// Każdy obiekt tej klasy zawiera pola (które nie są statyczne).
	String imie, nazwisko;
	int wiek;
	
	// Klasa może posiadać wiele konstruktorów, które różnią się liczbą lub typem parametrów
	Osoba() {
		
	}
	
	Osoba(String imie, String nazwisko, int wiek) {
		this.imie = imie;
		this.nazwisko = nazwisko;
		this.wiek = wiek;
	}
	
	{ // blok inicjalizacyjny - fragment kodu, który wykona się podczas tworzenia każdego obiektu
	  // jeszcze przed konstruktorem
		System.out.println("powstaje obiekt Osoba");
	}
	
	static {
		// blok inicjalizacyjny statyczny - wykonuje się raz, gdy klasa jest ładowana do maszyny wirtualnej
		System.out.println("static Osoba");
	}
	
	// Metoda to czynność, którą "potrafi wykonać obiekt".
	// nie piszemy już "static"
	// Wewnątrz metody można odwoływać się do pól należących do obiektu.
	// Te odwołania można poprzedzać this ("ten obiekt, w którym jesteśmy), ale w Javie nie trzeba tego robić.
	void przedstawSie() {
		System.out.println("Nazywam się " + imie + " " + nazwisko + " i mam " + wiek + " lat.");
	}
	
	boolean pelnoletnia() {
		return wiek >= 18;
	}
	
	@Override
	public String toString() {
		return imie + " " + nazwisko + " (" + wiek + " lat)";
	}
	
// Błędna realizacja equals - jako parametr zadeklarowana Osoba
//	public boolean equals(Osoba other) {
//		return this.imie.equals(other.imie)
//				&& this.nazwisko.equals(other.nazwisko)
//				&& this.wiek == other.wiek;
//	}
	
	// Prawdziwa metoda equals jako swój parametr musi przyjmować Object
	// Tutaj wygenerujemy standardowe implementacje equals i hashCode oferowane przez edytor
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Osoba other = (Osoba) obj;
		return Objects.equals(imie, other.imie) && Objects.equals(nazwisko, other.nazwisko) && wiek == other.wiek;
	}
	
	@Override
	public int hashCode() {
		return Objects.hash(imie, nazwisko, wiek);
	}
	
}
