package p11_klasy.podstawy_v1;

public class Przyklad0 {

	public static void main(String[] args) {
		// Dzięki temu, że istnieje klasa Osoba, możemy zadeklarować zmienną typu Osoba.
		Osoba o;
		
		// ale uwaga - w Javie sama deklaracja zmiennej nie tworzy obiektu
		// System.out.println(o); - błąd kompilacji - niezainicjowana zmienna
		
		// można też utworzyć nowy obiekt klasy Osoba i wpisać go do zmiennej
		o = new Osoba();
		System.out.println(o);
		
		// Najczęściej w jednej linii deklaruje się zmienną i wpisuje nowy obiekt:
		Osoba p = new Osoba();
		System.out.println(p);
		
		// Każdy obiekt w języku Java (nawet zupełnie pustej klasy)
		// posiada pewne metody, które można uruchomić.
		// toString - zwraca tekstową postać obiektu
		String s = o.toString();
		System.out.println(s);
		
		// getClass - zwraca "obiekt klasy" z informacjami nt klasy, do której należy obiekt
		System.out.println(o.getClass());
		Class<?> klasa = o.getClass();
		System.out.println("pakiet: "  + klasa.getPackageName() + ", klasa " + klasa.getSimpleName());

		// equals i hashCode związane z porównywaniem obiektów
		System.out.println("hasz o : " + o.hashCode());
		System.out.println("hasz p : " + p.hashCode());
		if(o.equals(p)) {
			System.out.println("obiekty równe");
		} else {
			System.out.println("obiekty nierówne");			
		}
		
		// metody wait (z kilku wersjach) i notify - służą do synchronizacji wątków w aplikacjach wielowątkowych
		
		// toString, equals, hashCode często są nadpisywane przez autorów klas.
	}

}
