package p11_klasy.enkapsulacja;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StudentZTablica extends Osoba {
	private String kierunek;
	private int rok;
	private int[] oceny = new int[5];
	private int liczbaOcen = 0;
	
	public StudentZTablica(String imie, String nazwisko, LocalDate dataUrodzenia, String kierunek, int rok) {
		super(imie, nazwisko, dataUrodzenia);
		this.kierunek = kierunek;
		this.rok = rok;
	}
	
	public StudentZTablica(String imie, String nazwisko, String dataUrodzenia, String kierunek, int rok) {
		super(imie, nazwisko, dataUrodzenia);
		this.kierunek = kierunek;
		this.rok = rok;
	}
	
	@Override
	public String toString() {
		return super.toString() + ", student " + rok + " roku kierunku " + kierunek;
	}
	
	public String getKierunek() {
		return kierunek;
	}
	
	public int getRok() {
		return rok;
	}
	
	public void dodajOcene(int ocena) {
		// ważny schemat w programowaniu, używany m.in. przez klasy ArrayList, StringBuilder
		// gdy w tablicy brakuje miejsca, tworzymy nową tablicę 2x większą i kopiujemy do niej elementy
		if(liczbaOcen == oceny.length) {
			System.out.println("powiększanie tablicy");
			oceny = Arrays.copyOf(oceny, 2 * oceny.length);
		}
		oceny[liczbaOcen++] = ocena;
	}
	
	public List<Integer> getOceny() {
		List<Integer> lista = new ArrayList<>(liczbaOcen);
		for(int i = 0; i < liczbaOcen; i++) {
			lista.add(oceny[i]);
		}
		return lista;
	}
	
	public double sredniaOcen() {
		double suma = 0;
		for(int i = 0; i < liczbaOcen; i++) {
			suma += oceny[i];
		}
		return suma / liczbaOcen;
	}
	
}
