package p11_klasy.enkapsulacja;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Student extends Osoba {
	private String kierunek;
	private int rok;
	private List<Integer> oceny = new ArrayList<>();
	// tu zmienialiśmy reprezentację tablicową na listową
	// dzięki enkapsulacji mieliśmy pewność, że zmiany ograniczają się do klasy Student
	
	public Student(String imie, String nazwisko, LocalDate dataUrodzenia, String kierunek, int rok) {
		super(imie, nazwisko, dataUrodzenia);
		this.kierunek = kierunek;
		this.rok = rok;
	}
	
	public Student(String imie, String nazwisko, String dataUrodzenia, String kierunek, int rok) {
		super(imie, nazwisko, dataUrodzenia);
		this.kierunek = kierunek;
		this.rok = rok;
	}
	
	@Override
	public String toString() {
		return super.toString() + ", student " + rok + " roku kierunku " + kierunek;
	}
	
	public String getKierunek() {
		return kierunek;
	}
	
	public int getRok() {
		return rok;
	}
	
	public void dodajOcene(int ocena) {
		oceny.add(ocena);
	}
	
	public List<Integer> getOceny() {
		// zwracamy obiekt, poprzez który nie jest możliwa modyfikacja
		return Collections.unmodifiableList(oceny);
	}
	
	public double sredniaOcen() {
		double suma = 0;
		for(int ocena : oceny) {
			suma += ocena;
		}
		return suma / oceny.size();
	}
	
}
