package p11_klasy.enkapsulacja;

import java.time.LocalDate;
import java.time.Period;

public class Osoba {
	private String imie, nazwisko;
	private LocalDate dataUrodzenia;
	
	public Osoba(String imie, String nazwisko, LocalDate dataUrodzenia) {
		this.imie = imie;
		this.nazwisko = nazwisko;
		this.dataUrodzenia = dataUrodzenia;
	}
	
	public Osoba(String imie, String nazwisko, String dataUrodzenia) {
		this(imie, nazwisko, LocalDate.parse(dataUrodzenia));
	}
	
	@Override
	public String toString() {
		return imie + " " + nazwisko + " ur." + dataUrodzenia;
	}
	
	// accessors - metody dostępowe
	// getters and setters
	public String getImie() {
		return imie;
	}

	public void setImie(String imie) {
		this.imie = imie;
	}

	public String getNazwisko() {
		return nazwisko;
	}

	public void setNazwisko(String nazwisko) {
		this.nazwisko = nazwisko;
	}

	public LocalDate getDataUrodzenia() {
		return dataUrodzenia;
	}

	public int getWiek() {
		// to wygląda jak getter, ale oblicza wiek na podstawie daty.
		Period czasZycia = Period.between(dataUrodzenia, LocalDate.now());
		return czasZycia.getYears();
	}
	
}
