package p11_klasy.enkapsulacja;

public class Konto {
	private final int numer;
	private int saldo;
	private Osoba wlasciciel;
	
	public Konto(int numer, int saldo, Osoba wlasciciel) {
		if(saldo < 0) {
			throw new IllegalArgumentException("ujemne saldo");
		}
		this.numer = numer;
		this.saldo = saldo;
		setWlasciciel(wlasciciel);
	}
	
	@Override
	public String toString() {
		return "Konto nr " + numer + ", saldo " + saldo + " wł. " + wlasciciel;
	}
	
	// Dla pola numer nie tworzę settera, gdyż numer konta się nie zmienia.
	// Dodatkowo jest to zapewnione modyfikatorem final.
	
	// Dla pola saldo nie tworzę settera, gdyż salda nie ustawia się "bez żadnego trybu",
	// tylko saldo można zmodyfikować poprzez operacje biznesowe: wplata, wyplata, przelew.
	
	public int getNumer() {
		return numer;
	}

	public int getSaldo() {
		return saldo;
	}

	public Osoba getWlasciciel() {
		return wlasciciel;
	}
	
	public void setWlasciciel(Osoba wlasciciel) {
		if(wlasciciel == null) {
			throw new IllegalArgumentException("właśniciel null");
		}
		this.wlasciciel = wlasciciel;
	}
	
	public void wplata(int kwota) {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Kwota nie jest dodatnia");
		}
		// this.saldo += kwota;
		this.saldo = Math.addExact(this.saldo, kwota);
	}
	
	public void wyplata(int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Kwota nie jest dodatnia");
		}
		if(kwota > saldo) {
			throw new BrakSrodkow("Za mało kasy");
		}
		// this.saldo -= kwota;
		this.saldo = Math.subtractExact(this.saldo, kwota);
	}

	public void przelew(Konto inne, int kwota) throws BrakSrodkow {
		if(kwota <= 0) {
			throw new IllegalArgumentException("Kwota nie jest dodatnia");
		}
		if(kwota > saldo) {
			throw new BrakSrodkow("Za mało kasy");
		}
		this.saldo -= kwota;
		inne.saldo += kwota;
	}
}
