package p09_funkcje;

import java.util.Optional;

public class NajdluzszyNapis {
	
	// Funkcja zwraca najdłuższy z napisów przekazanych w tablicy.

	// Wersja "elegancka". Nie jest ona odporna na wszystkie przypadki:
	// - dla pustej tablicy wynikiem jest pusty napis (chociaż taki nie występuje w tej tablicy)
	// - jeśli tablica zawiera wartość null zamiast napisu, to wyjątek
	// - podobnie gdy zamiast samej tablicy jest null, to też wyjątek
	static String najdluzszy(String[] napisy) {
		String wynik = "";
		for (String napis : napisy) {
			if(napis.length() > wynik.length()) {
				wynik = napis;
			}
		}
		return wynik;
	}
	
	// wersja odporna na puste tablice i nulle
	// w przypadku braku danych zwraca wynik null
	// w tej funcji w dwóch miejscach korzystamy z faktu, że spójniki logiczne w Javie są "leniwe"
	// i prawa strona || i && jest sprawdzana tylko wtedy, gdy trzeba
	static String najdluzszy2(String[] napisy) {
		if(napisy == null || napisy.length == 0) {
			return null;
		}
		
		String wynik = "";
		for(String s : napisy) {
			if(s != null && s.length() > wynik.length()) {
				wynik = s;
			}
		}
		return wynik;
	}
	
	// Od Javy 8 dostępne są klasy Optional, OptionalInt / Long / Double
	// Używa się ich, aby nie trzeba było zwracać wartości null, gdy funkcja czasami daje wynik, a czasami nie
	static Optional<String> najdluzszy3(String[] napisy) {
		if(napisy == null || napisy.length == 0) {
			return Optional.empty();
		}
		
		String wynik = "";
		for(String s : napisy) {
			if(s != null && s.length() > wynik.length()) {
				wynik = s;
			}
		}
		return Optional.of(wynik);
	}

	public static void main(String[] args) {
		String[] napisy = {
			"abc",
			"Cyrk na kółkach",
			"Ala ma kota i psa i nie wiem co jeszcze",
			null,
			"abc abc abc",
		};
		
		String[] pusta = {};
		
		System.out.println("Najsłuższy napis:");
		System.out.println(najdluzszy2(napisy));
		System.out.println("wynik dla pustej: " + najdluzszy2(pusta));
		System.out.println();
		System.out.println("Wersja z Optional:");
		System.out.println(najdluzszy3(napisy));
		System.out.println("wynik dla pustej: " + najdluzszy3(pusta));
		
		Optional<String> opt = najdluzszy3(napisy);
		// to nie jest jedyny sposób używania Optionali:
		if(opt.isPresent()) {
			System.out.println("Mam wynik: " + opt.get());
		} else {
			System.out.println("Brak wyniku");
		}
	}

}
