package p09_funkcje;

import java.util.Arrays;
import java.util.Scanner;

public class FunkcjeTekstowe {
	
	static int ileA(String tekst) {
		int ile = 0;
		for(int i = 0; i < tekst.length(); i++) {
			if(tekst.charAt(i) == 'a') {
				ile++;
			}
		}
		return ile;
	}
	
	// funkcja oblicza, ile łącznie samogłosek (liter a e i o u y ą ę ó) zawiera tekst
	static int ileSamoglosek(String tekst) {
		tekst = tekst.toLowerCase();
		int ile = 0;
		for(int i = 0; i < tekst.length(); i++) {
			if(tekst.charAt(i) == 'a' || tekst.charAt(i) == 'e' || tekst.charAt(i) == 'i'
				 || tekst.charAt(i) == 'o' || tekst.charAt(i) == 'u' || tekst.charAt(i) == 'y'
				 || tekst.charAt(i) == 'ą' || tekst.charAt(i) == 'ę' || tekst.charAt(i) == 'ó') {
				ile++;
			}
		}
		return ile;
	}
	
	static int ileSamoglosek_v2(String tekst) {
		int ile = 0;
		for(char c : tekst.toLowerCase().toCharArray()) {
			switch(c) {
				case 'a', 'e', 'i', 'o', 'u', 'y', 'ą', 'ę', 'ó' -> ile++;
			}
		}
		return ile;
	}
	
	// dodatkowa wersja w oparciu o Stream.
	// w sprawdzaniu czy litera jest samogłoską używam binarySearch - to wymaga, aby tablica samogłosek była posortowana rosną wg kodów znaków
	static long ileSamoglosek_v3(String tekst) {
		final int[] samogloski = {'a', 'e', 'i', 'o', 'u', 'y', 'ó', 'ą', 'ę'};
		return tekst.toLowerCase().chars()
				.filter(c -> Arrays.binarySearch(samogloski, c) >= 0)
				.count();
	}

	// funkcja sprawdza, czy napis jest palindromem (np "kajak") i zwraca true lub false
	static boolean palindrom(String tekst) {
		for(int i = 0; i < tekst.length() / 2; i++) {
			if(tekst.charAt(i) != tekst.charAt(tekst.length() - i - 1)) {
				return false;
			}
		}
		// jeśli wcześniej nie było powodu, aby zwrócić false, to zwracamy true
		return true;
	}

	// rozwiązanie z dwoma licznikami
	static boolean palindrom_v2(String tekst) {
		for(int i = 0, j = tekst.length()-1; i < j; i++, j--) {
			if(tekst.charAt(i) != tekst.charAt(j)) {
				return false;
			}
		}
		return true;
	}

	public static void main(String[] args) {
		// W tym przykładzie użytkownik będzie podawał swoje przykładowe teksty,
		// a program będzie uruchamiał przygotowane funkcje na tym tekście.
		Scanner scanner = new Scanner(System.in);
		System.out.println("Podawaj swoje teksty. Aby zakończyć, naciśnij enter");
		
		while(true) {
			System.out.print("\nWpisz tekst: ");
			String tekst = scanner.nextLine();
			if(tekst.isEmpty()) break;
			int ileA = ileA(tekst);
			int ileS = ileSamoglosek(tekst);
			int ileS2 = ileSamoglosek_v2(tekst);
			long ileS3 = ileSamoglosek_v3(tekst);
			System.out.println("Liczba liter a: " + ileA);
			System.out.println("Liczba samogłosek v1: " + ileS);
			System.out.println("Liczba samogłosek v2: " + ileS2);
			System.out.println("Liczba samogłosek v3: " + ileS3);
			if(palindrom(tekst)) {
				System.out.println("Napis jest palindromem");
			} else {
				System.out.println("Napis nie jest palindromem");				
			}
			if(palindrom_v2(tekst)) {
				System.out.println("Napis jest palindromem");
			} else {
				System.out.println("Napis nie jest palindromem");				
			}
		}
		System.out.println("Koniec programu");
	}

}
