package p09_funkcje;

import java.time.LocalTime;

public class EkstremalnieProsteFunkcje {
	
	// Funkcja ma wypisać podany tekst tyle razy, ile mówi drugi parametr
	static void powtorz(String napis, int ileRazy) {
		for(int i = 0; i < ileRazy; i++) {
			System.out.println(napis);
		}
	}
	
	// pole prostokąta
	static double poleProstokata(double a, double b) {
		return a*b;
	}
	
	// zwraca najmniejszy z trzech podanych argumentów
	static double min(double x, double y, double z) {
		if(x < y && x < z) {
			return x;
		}
		if(y < z) {
			return y;
		}
		return z;
	}
	
	// wyrażenie warunkowe:   WARUNEK ? WYNIK1 : WYNIK2
	static double min2(double x, double y, double z) {
		return x < y && x < z ? x : y < z ? y : z;
	}
	
	// zwraca ostatnią cyfrę aktualnej sekundy odczytanej z zegara
	static int aktualnaSekunda() {
		return LocalTime.now().getSecond() % 10;
	}

	public static void main(String[] args) {
		powtorz("Ala ma kota", 5);
		powtorz("Ola ma psa", 3);
		System.out.println();
		
		double pole = poleProstokata(3, 4);
		System.out.println("Pole 3×4 = " + pole);
		System.out.println();
		
		System.out.println(min(1,2,3));
		System.out.println(min(3,1,3));
		System.out.println(min(1,1,1));
		System.out.println(min(1,3,2));
		System.out.println(min2(1,2,3));
		System.out.println(min2(3,1,3));
		System.out.println(min2(1,1,1));
		System.out.println(min2(1,3,2));
		System.out.println();
		System.out.println("aktualna sekunda: " + aktualnaSekunda());
	}

}
