package p06_switch;

import javax.swing.JOptionPane;

public class DzienTygodnia7 {
	// W tej wersji używamy "switch expression" - od Java 14.
	// switch expression to jest coś, co przypomina funkcję i zwraca jedną z z wartości na podstawie argumentu.
	// (tutaj na podstawie wartości numer zwracane są napisy "poniedziałek" albo "wtorek" itd)
	// ale nie jest to pisane jako odzielna funkcja, która ma swoją nazwę i może być wywoływana z różnych miejsc,
	// tylko jest to wpisane w formie switcha w tym miejcu, gdzie jest potrzebne.
	
	public static void main(String[] args) {
		try {
			int numer = Integer.parseInt(JOptionPane.showInputDialog("Podaj numer dnia tygodnia"));
			String nazwa = switch (numer) {
				case 1  -> "poniedziałek";
				case 2  -> "wtorek";
				case 3  -> "środa";
				case 4  -> "czwartek";
				case 5  -> "piątek";
				case 6  -> "sobota";
				case 7  -> "niedziela";
				default -> throw new IllegalArgumentException("Niepoprawny numer");
			};
			JOptionPane.showMessageDialog(null, "To jest " + nazwa);
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e, "Błąd!", JOptionPane.ERROR_MESSAGE);
		}
		JOptionPane.showMessageDialog(null, "Koniec programu");
	}

}
