package p01_zmienne;

public class TeoriaZmiennych {

	public static void main(String[] args) {
		// W Javie nie wolno używać zmiennych, które nie są zadeklarowane
		// System.out.println(zmienna);
		// Nie można nawet wpisać wartości do zmiennej (co można w Python, PHP, JS)
		// zmienna = 123;
		
		// Deklaracja zmiennej wygląda tak: typ zmienna
		int zmienna;
		// Od tego miejsca do końca bieżącego {bloku} można używać tej zmiennej
		zmienna = 321;
		System.out.println(zmienna);
		zmienna += 5;
		System.out.println(zmienna);
		
		// Uwaga. W Javie nie wolno odczytywać wartości zmiennej lokalnej, do której nie wpisaliśmy żadnej wartości.
		int x, y;
		// To się nie kompiluje:
//		if(x > 0) {
//			System.out.println(y);
//		}
		
		x = 20;
		System.out.println(x); // OK
		if(x > 0) {
			y = 200;
		}
		// Tutaj kompilator nie ma pewności, że y posiada jakąś wartość, bo teoretycznie program mógł nie wejść do ifa
		// System.out.println(y);
		if(x > 0) {
			y = 200;
		} else {
			y = 100;
		}
		System.out.println(y); // teraz OK
		
		// Najczęściej w Javie zmienne deklaruje się dopiero wtedy, gdy są potrzebne,
		// i od razu wpisuje do nich początkową wartość:
		String imie = "Ala";
		int liczba = 333;
		double pi = 3.14;
		System.out.println(imie + " " + liczba + " " + pi);
		
		// Od Javy 10 zmienne lokalne można dekalrować bez podania typu, za pomocą słowa var
		// Typ zmiennej jest wówczas ustalany na podstawie wartości wpisywanej.
		
		var a = "Ola ma psa";
		System.out.println(a);
		// teraz zmienna a jest typu String - nie wolno wpisać innych wartości
		//błąd! a = 5432;
		
		// Typem uniwersalnym, że do zmiennej można wpisać praktycznie wszystko, jest Object
		
		Object o;
		o = "Ula ma rybki";
		System.out.println(o);
		
		o = 12 * 34; // mówiąc precyzyjnie, powstaje tu obiekt klasy Integer
		System.out.println(o);
	}

}
